//
//  CRPreset.h
//  CRGraphics
//
//  Created by Yaroslav Glushchenko on 10/19/09.
//  Copyright 2009 Corner-A. All rights reserved.
//

//////////////////////////////////////////////////////////////////////
// Scene preset:
// A library item that store whole scene
//////////////////////////////////////////////////////////////////////
@interface CRPreset : CRLibraryItemBase
{
	NSImage* preview;
}

@property (nonatomic, strong) CRScene*	scene;
@property (nonatomic, assign) int		rating;
@property (nonatomic, strong) NSImage*	preview;

@property (assign, getter = isGeneratingPreview) BOOL generatingPreview;

+ (id)presetFromFile:(NSString *)filePath;
- (BOOL)saveToFile:(NSString *)filePath;

- (BOOL)isGeneratingPreview;
- (void)generatePreviewWithData:(NSDictionary *)data;

@end